/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolProfile;

public class CamelCustomDefaultThreadPoolProfileTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camel = super.createCamelContext();
        ThreadPoolProfile profile = new ThreadPoolProfile("custom");
        profile.setPoolSize(Integer.valueOf(5));
        profile.setMaxPoolSize(Integer.valueOf(15));
        profile.setKeepAliveTime(Long.valueOf(25L));
        profile.setMaxQueueSize(Integer.valueOf(250));
        profile.setAllowCoreThreadTimeOut(Boolean.valueOf(true));
        profile.setRejectedPolicy(ThreadPoolRejectedPolicy.Abort);
        camel.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
        return camel;
    }

    public void testCamelCustomDefaultThreadPoolProfile() throws Exception {
        DefaultExecutorServiceManager manager = (DefaultExecutorServiceManager)this.context.getExecutorServiceManager();
        ThreadPoolProfile profile = manager.getDefaultThreadPoolProfile();
        CamelCustomDefaultThreadPoolProfileTest.assertEquals((int)5, (int)profile.getPoolSize());
        CamelCustomDefaultThreadPoolProfileTest.assertEquals((int)15, (int)profile.getMaxPoolSize());
        CamelCustomDefaultThreadPoolProfileTest.assertEquals((long)25L, (long)profile.getKeepAliveTime());
        CamelCustomDefaultThreadPoolProfileTest.assertEquals((int)250, (int)profile.getMaxQueueSize());
        CamelCustomDefaultThreadPoolProfileTest.assertEquals((boolean)true, (boolean)profile.getAllowCoreThreadTimeOut());
        CamelCustomDefaultThreadPoolProfileTest.assertEquals((Object)ThreadPoolRejectedPolicy.Abort, (Object)profile.getRejectedPolicy());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").threads(25, 45).to("mock:result");
            }
        };
    }
}

