/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Consume;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultCamelBeanPostProcessor;

public class DefaultCamelBeanPostProcessorTest
extends ContextTestSupport {
    private DefaultCamelBeanPostProcessor postProcessor;

    public void testPostProcessor() throws Exception {
        FooService foo = new FooService();
        foo.setFooEndpoint("seda:input");
        foo.setBarEndpoint("mock:result");
        this.postProcessor.postProcessBeforeInitialization((Object)foo, "foo");
        this.postProcessor.postProcessAfterInitialization((Object)foo, "foo");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:input", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.postProcessor = new DefaultCamelBeanPostProcessor((CamelContext)this.context);
    }

    public class FooService {
        private String fooEndpoint;
        private String barEndpoint;
        @Produce
        private ProducerTemplate bar;

        public String getFooEndpoint() {
            return this.fooEndpoint;
        }

        public void setFooEndpoint(String fooEndpoint) {
            this.fooEndpoint = fooEndpoint;
        }

        public String getBarEndpoint() {
            return this.barEndpoint;
        }

        public void setBarEndpoint(String barEndpoint) {
            this.barEndpoint = barEndpoint;
        }

        @Consume
        public void onFoo(String input) {
            this.bar.sendBody((Object)input);
        }
    }
}

