/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.DefaultCamelContext;

public class DefaultCamelContextLazyLoadTypeConvertersTest
extends TestSupport {
    private CamelContext context = new DefaultCamelContext();

    public void testLazyLoadDefault() throws Exception {
        DefaultCamelContextLazyLoadTypeConvertersTest.assertFalse((String)"Default setting should have been true", (boolean)this.context.isLazyLoadTypeConverters());
    }

    public void testConvertLoadUpFront() throws Exception {
        this.context.setLazyLoadTypeConverters(Boolean.valueOf(false));
        this.doConvertTest();
    }

    public void testConvertLazyLoad() throws Exception {
        this.context.setLazyLoadTypeConverters(Boolean.valueOf(true));
        this.doConvertTest();
    }

    private void doConvertTest() throws Exception {
        this.context.start();
        this.convert();
        this.context.stop();
        this.convert();
    }

    private void convert() throws Exception {
        TypeConverter converter = this.context.getTypeConverter();
        Integer value = (Integer)converter.convertTo(Integer.class, (Object)"1000");
        DefaultCamelContextLazyLoadTypeConvertersTest.assertNotNull((Object)value);
        DefaultCamelContextLazyLoadTypeConvertersTest.assertEquals((String)"Converted to Integer", (Object)new Integer(1000), (Object)value);
        String text = (String)converter.convertTo(String.class, (Object)value);
        DefaultCamelContextLazyLoadTypeConvertersTest.assertEquals((String)"Converted to String", (String)"1000", (String)text);
    }
}

