/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;

public class DefaultCamelContextWithLifecycleStrategyRestartTest
extends ContextTestSupport {
    private MyStrategy strategy = new MyStrategy();

    public void testRestart() throws Exception {
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertTrue((boolean)this.context.getStatus().isStarted());
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertFalse((boolean)this.context.getStatus().isStopped());
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertEquals((int)1, (int)this.strategy.getContextStartCounter());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertFalse((boolean)this.context.getStatus().isStarted());
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertTrue((boolean)this.context.getStatus().isStopped());
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.start();
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertTrue((boolean)this.context.getStatus().isStarted());
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertFalse((boolean)this.context.getStatus().isStopped());
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertEquals((int)2, (int)this.strategy.getContextStartCounter());
        this.template = this.context.createProducerTemplate();
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testRouteStopped() throws Exception {
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertTrue((boolean)this.context.getRouteStatus("foo").isStarted());
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertEquals((int)0, (int)this.strategy.getRemoveCounter());
        this.context.stopRoute("foo");
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertEquals((int)0, (int)this.strategy.getRemoveCounter());
        this.context.removeRoute("foo");
        DefaultCamelContextWithLifecycleStrategyRestartTest.assertEquals((int)1, (int)this.strategy.getRemoveCounter());
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addLifecycleStrategy((LifecycleStrategy)this.strategy);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        };
    }

    private class MyStrategy
    extends LifecycleStrategySupport {
        private AtomicInteger contextStartCounter = new AtomicInteger();
        private AtomicInteger removeCounter = new AtomicInteger();

        private MyStrategy() {
        }

        public void onContextStart(CamelContext context) throws VetoCamelContextStartException {
            this.contextStartCounter.incrementAndGet();
        }

        public void onRoutesRemove(Collection<Route> routes) {
            this.removeCounter.incrementAndGet();
        }

        public int getContextStartCounter() {
            return this.contextStartCounter.get();
        }

        public int getRemoveCounter() {
            return this.removeCounter.get();
        }
    }
}

