/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.net.ConnectException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTestSupport;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ObjectHelper;

public class DefaultExchangeTest
extends ExchangeTestSupport {
    public void testBody() throws Exception {
        DefaultExchangeTest.assertNotNull((Object)this.exchange.getIn().getBody());
        DefaultExchangeTest.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getBody());
        DefaultExchangeTest.assertEquals((String)"<hello id='m123'>world!</hello>", (String)((String)this.exchange.getIn().getBody(String.class)));
        DefaultExchangeTest.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getMandatoryBody());
        DefaultExchangeTest.assertEquals((String)"<hello id='m123'>world!</hello>", (String)((String)this.exchange.getIn().getMandatoryBody(String.class)));
    }

    public void testMandatoryBody() throws Exception {
        DefaultExchangeTest.assertNotNull((Object)this.exchange.getIn().getBody());
        DefaultExchangeTest.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getBody());
        try {
            DefaultExchangeTest.assertEquals(null, (Object)this.exchange.getIn().getBody(Integer.class));
            DefaultExchangeTest.fail((String)"Should have thrown a TypeConversionException");
        }
        catch (TypeConversionException typeConversionException) {
            // empty catch block
        }
        DefaultExchangeTest.assertEquals((Object)"<hello id='m123'>world!</hello>", (Object)this.exchange.getIn().getMandatoryBody());
        try {
            this.exchange.getIn().getMandatoryBody(Integer.class);
            DefaultExchangeTest.fail((String)"Should have thrown an InvalidPayloadException");
        }
        catch (InvalidPayloadException invalidPayloadException) {
            // empty catch block
        }
    }

    public void testExceptionAsType() throws Exception {
        this.exchange.setException((Throwable)ObjectHelper.wrapRuntimeCamelException((Throwable)new ConnectException("Cannot connect to remote server")));
        ConnectException ce = (ConnectException)this.exchange.getException(ConnectException.class);
        DefaultExchangeTest.assertNotNull((Object)ce);
        DefaultExchangeTest.assertEquals((String)"Cannot connect to remote server", (String)ce.getMessage());
        IOException ie = (IOException)this.exchange.getException(IOException.class);
        DefaultExchangeTest.assertNotNull((Object)ie);
        DefaultExchangeTest.assertEquals((String)"Cannot connect to remote server", (String)ie.getMessage());
        Exception e = (Exception)this.exchange.getException(Exception.class);
        DefaultExchangeTest.assertNotNull((Object)e);
        DefaultExchangeTest.assertEquals((String)"Cannot connect to remote server", (String)e.getMessage());
        RuntimeCamelException rce = (RuntimeCamelException)((Object)this.exchange.getException(RuntimeCamelException.class));
        DefaultExchangeTest.assertNotNull((Object)((Object)rce));
        DefaultExchangeTest.assertNotSame((Object)"Cannot connect to remote server", (Object)rce.getMessage());
        DefaultExchangeTest.assertEquals((String)"Cannot connect to remote server", (String)rce.getCause().getMessage());
    }

    public void testHeader() throws Exception {
        DefaultExchangeTest.assertNotNull((Object)this.exchange.getIn().getHeaders());
        DefaultExchangeTest.assertEquals((Object)123, (Object)this.exchange.getIn().getHeader("bar"));
        DefaultExchangeTest.assertEquals((Object)new Integer(123), (Object)this.exchange.getIn().getHeader("bar", Integer.class));
        DefaultExchangeTest.assertEquals((String)"123", (String)((String)this.exchange.getIn().getHeader("bar", String.class)));
        DefaultExchangeTest.assertEquals((Object)123, (Object)this.exchange.getIn().getHeader("bar", (Object)234));
        DefaultExchangeTest.assertEquals((Object)123, (Object)this.exchange.getIn().getHeader("bar", (Object)234));
        DefaultExchangeTest.assertEquals((Object)new Integer(123), (Object)this.exchange.getIn().getHeader("bar", (Object)234, Integer.class));
        DefaultExchangeTest.assertEquals((String)"123", (String)((String)this.exchange.getIn().getHeader("bar", (Object)"234", String.class)));
        DefaultExchangeTest.assertEquals((Object)234, (Object)this.exchange.getIn().getHeader("cheese", (Object)234));
        DefaultExchangeTest.assertEquals((String)"234", (String)((String)this.exchange.getIn().getHeader("cheese", (Object)234, String.class)));
    }

    public void testProperty() throws Exception {
        this.exchange.removeProperty("foobar");
        DefaultExchangeTest.assertFalse((boolean)this.exchange.hasProperties());
        this.exchange.setProperty("fruit", (Object)"apple");
        DefaultExchangeTest.assertTrue((boolean)this.exchange.hasProperties());
        DefaultExchangeTest.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit"));
        DefaultExchangeTest.assertEquals(null, (Object)this.exchange.getProperty("beer"));
        DefaultExchangeTest.assertEquals(null, (String)((String)this.exchange.getProperty("beer", String.class)));
        DefaultExchangeTest.assertEquals((Object)Boolean.FALSE, (Object)this.exchange.getProperty("beer", Boolean.TYPE));
        DefaultExchangeTest.assertEquals(null, (Object)this.exchange.getProperty("beer", Boolean.class));
        DefaultExchangeTest.assertEquals((String)"apple", (String)((String)this.exchange.getProperty("fruit", String.class)));
        DefaultExchangeTest.assertEquals((String)"apple", (String)((String)this.exchange.getProperty("fruit", (Object)"banana", String.class)));
        DefaultExchangeTest.assertEquals((Object)"banana", (Object)this.exchange.getProperty("beer", (Object)"banana"));
        DefaultExchangeTest.assertEquals((String)"banana", (String)((String)this.exchange.getProperty("beer", (Object)"banana", String.class)));
    }

    public void testRemoveProperties() throws Exception {
        this.exchange.removeProperty("foobar");
        DefaultExchangeTest.assertFalse((boolean)this.exchange.hasProperties());
        this.exchange.setProperty("fruit", (Object)"apple");
        this.exchange.setProperty("fruit1", (Object)"banana");
        this.exchange.setProperty("zone", (Object)"Africa");
        DefaultExchangeTest.assertTrue((boolean)this.exchange.hasProperties());
        DefaultExchangeTest.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit"));
        DefaultExchangeTest.assertEquals((Object)"banana", (Object)this.exchange.getProperty("fruit1"));
        DefaultExchangeTest.assertEquals((Object)"Africa", (Object)this.exchange.getProperty("zone"));
        this.exchange.removeProperties("fr*");
        DefaultExchangeTest.assertTrue((boolean)this.exchange.hasProperties());
        DefaultExchangeTest.assertEquals((int)this.exchange.getProperties().size(), (int)1);
        DefaultExchangeTest.assertEquals(null, (String)((String)this.exchange.getProperty("fruit", String.class)));
        DefaultExchangeTest.assertEquals(null, (String)((String)this.exchange.getProperty("fruit1", String.class)));
        DefaultExchangeTest.assertEquals((String)"Africa", (String)((String)this.exchange.getProperty("zone", String.class)));
    }

    public void testRemovePropertiesWithExclusion() throws Exception {
        this.exchange.removeProperty("foobar");
        DefaultExchangeTest.assertFalse((boolean)this.exchange.hasProperties());
        this.exchange.setProperty("fruit", (Object)"apple");
        this.exchange.setProperty("fruit1", (Object)"banana");
        this.exchange.setProperty("fruit2", (Object)"peach");
        this.exchange.setProperty("zone", (Object)"Africa");
        DefaultExchangeTest.assertTrue((boolean)this.exchange.hasProperties());
        DefaultExchangeTest.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit"));
        DefaultExchangeTest.assertEquals((Object)"banana", (Object)this.exchange.getProperty("fruit1"));
        DefaultExchangeTest.assertEquals((Object)"peach", (Object)this.exchange.getProperty("fruit2"));
        DefaultExchangeTest.assertEquals((Object)"Africa", (Object)this.exchange.getProperty("zone"));
        this.exchange.removeProperties("fr*", new String[]{"fruit1", "fruit2"});
        DefaultExchangeTest.assertTrue((boolean)this.exchange.hasProperties());
        DefaultExchangeTest.assertEquals((int)this.exchange.getProperties().size(), (int)3);
        DefaultExchangeTest.assertEquals(null, (String)((String)this.exchange.getProperty("fruit", String.class)));
        DefaultExchangeTest.assertEquals((String)"banana", (String)((String)this.exchange.getProperty("fruit1", String.class)));
        DefaultExchangeTest.assertEquals((String)"peach", (String)((String)this.exchange.getProperty("fruit2", String.class)));
        DefaultExchangeTest.assertEquals((String)"Africa", (String)((String)this.exchange.getProperty("zone", String.class)));
    }

    public void testRemovePropertiesPatternWithAllExcluded() throws Exception {
        this.exchange.removeProperty("foobar");
        DefaultExchangeTest.assertFalse((boolean)this.exchange.hasProperties());
        this.exchange.setProperty("fruit", (Object)"apple");
        this.exchange.setProperty("fruit1", (Object)"banana");
        this.exchange.setProperty("fruit2", (Object)"peach");
        this.exchange.setProperty("zone", (Object)"Africa");
        DefaultExchangeTest.assertTrue((boolean)this.exchange.hasProperties());
        DefaultExchangeTest.assertEquals((Object)"apple", (Object)this.exchange.getProperty("fruit"));
        DefaultExchangeTest.assertEquals((Object)"banana", (Object)this.exchange.getProperty("fruit1"));
        DefaultExchangeTest.assertEquals((Object)"peach", (Object)this.exchange.getProperty("fruit2"));
        DefaultExchangeTest.assertEquals((Object)"Africa", (Object)this.exchange.getProperty("zone"));
        this.exchange.removeProperties("fr*", new String[]{"fruit", "fruit1", "fruit2", "zone"});
        DefaultExchangeTest.assertTrue((boolean)this.exchange.hasProperties());
        DefaultExchangeTest.assertEquals((int)this.exchange.getProperties().size(), (int)4);
        DefaultExchangeTest.assertEquals((String)"apple", (String)((String)this.exchange.getProperty("fruit", String.class)));
        DefaultExchangeTest.assertEquals((String)"banana", (String)((String)this.exchange.getProperty("fruit1", String.class)));
        DefaultExchangeTest.assertEquals((String)"peach", (String)((String)this.exchange.getProperty("fruit2", String.class)));
        DefaultExchangeTest.assertEquals((String)"Africa", (String)((String)this.exchange.getProperty("zone", String.class)));
    }

    public void testInType() throws Exception {
        this.exchange.setIn((Message)new MyMessage());
        MyMessage my = (MyMessage)((Object)this.exchange.getIn(MyMessage.class));
        DefaultExchangeTest.assertNotNull((Object)((Object)my));
    }

    public void testOutType() throws Exception {
        this.exchange.setOut((Message)new MyMessage());
        MyMessage my = (MyMessage)((Object)this.exchange.getOut(MyMessage.class));
        DefaultExchangeTest.assertNotNull((Object)((Object)my));
    }

    public void testCopy() {
        DefaultExchange sourceExchange = new DefaultExchange((CamelContext)this.context);
        MyMessage sourceIn = new MyMessage();
        sourceExchange.setIn((Message)sourceIn);
        Exchange destExchange = sourceExchange.copy();
        Message destIn = destExchange.getIn();
        DefaultExchangeTest.assertEquals((String)"Dest message should be of the same type as source message", ((Object)((Object)sourceIn)).getClass(), destIn.getClass());
    }

    public static class MyMessage
    extends DefaultMessage {
        public MyMessage newInstance() {
            return new MyMessage();
        }
    }
}

