/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.impl.EventDrivenPollingConsumer;
import org.apache.camel.util.ServiceHelper;

public class EventDrivenPollingConsumerQueueSizeTest
extends ContextTestSupport {
    private String uri = "my:foo?pollingConsumerQueueSize=10&pollingConsumerBlockWhenFull=false";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.context.addComponent("my", (Component)new MyQueueComponent());
    }

    public void testQueueSize() throws Exception {
        PollingConsumer consumer = this.context.getEndpoint(this.uri).createPollingConsumer();
        consumer.start();
        EventDrivenPollingConsumerQueueSizeTest.assertNotNull((Object)consumer);
        EventDrivenPollingConsumer edpc = EventDrivenPollingConsumerQueueSizeTest.assertIsInstanceOf(EventDrivenPollingConsumer.class, consumer);
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)0, (int)edpc.getQueueSize());
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)10, (int)edpc.getQueueCapacity());
        EventDrivenPollingConsumerQueueSizeTest.assertFalse((boolean)edpc.isBlockWhenFull());
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody(this.uri, (Object)("Message " + i));
        }
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)10, (int)edpc.getQueueSize());
        try {
            this.template.sendBody(this.uri, (Object)"Message 10");
            EventDrivenPollingConsumerQueueSizeTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            EventDrivenPollingConsumerQueueSizeTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
        }
        Exchange out = consumer.receive(5000L);
        EventDrivenPollingConsumerQueueSizeTest.assertNotNull((Object)out);
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((Object)"Message 0", (Object)out.getIn().getBody());
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)9, (int)edpc.getQueueSize());
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)10, (int)edpc.getQueueCapacity());
        this.template.sendBody(this.uri, (Object)"Message 10");
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)10, (int)edpc.getQueueSize());
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)10, (int)edpc.getQueueCapacity());
        ServiceHelper.stopService((Object)consumer);
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)10, (int)edpc.getQueueSize());
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)10, (int)edpc.getQueueCapacity());
        ServiceHelper.stopAndShutdownService((Object)consumer);
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)0, (int)edpc.getQueueSize());
        EventDrivenPollingConsumerQueueSizeTest.assertEquals((int)10, (int)edpc.getQueueCapacity());
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private final class MyQueueEndpoint
    extends DefaultEndpoint {
        private EventDrivenPollingConsumer consumer;

        private MyQueueEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public Producer createProducer() throws Exception {
            return new DefaultProducer((Endpoint)this){

                public void process(Exchange exchange) throws Exception {
                    MyQueueEndpoint.this.consumer.process(exchange);
                }
            };
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return this.consumer;
        }

        public PollingConsumer createPollingConsumer() throws Exception {
            return this.consumer;
        }

        public boolean isSingleton() {
            return true;
        }

        protected void doStart() throws Exception {
            this.consumer = (EventDrivenPollingConsumer)super.createPollingConsumer();
            super.doStart();
        }
    }

    private final class MyQueueComponent
    extends DefaultComponent {
        private MyQueueComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return new MyQueueEndpoint(uri, (Component)this);
        }
    }
}

