/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import junit.framework.TestCase;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;

public class GetRegistryAsTypeTest
extends TestCase {
    public void testDefault() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        JndiRegistry jndi = (JndiRegistry)context.getRegistry(JndiRegistry.class);
        GetRegistryAsTypeTest.assertNotNull((Object)jndi);
        GetRegistryAsTypeTest.assertNull((Object)context.getRegistry(Map.class));
        GetRegistryAsTypeTest.assertNull((Object)context.getRegistry(SimpleRegistry.class));
        context.stop();
    }

    public void testSimple() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)new SimpleRegistry());
        context.start();
        SimpleRegistry simple = (SimpleRegistry)context.getRegistry(SimpleRegistry.class);
        GetRegistryAsTypeTest.assertNotNull((Object)simple);
        GetRegistryAsTypeTest.assertNotNull((Object)context.getRegistry(Map.class));
        GetRegistryAsTypeTest.assertNull((Object)context.getRegistry(JndiRegistry.class));
        context.stop();
    }

    public void testComposite() throws Exception {
        CompositeRegistry cr = new CompositeRegistry();
        cr.addRegistry((Registry)new SimpleRegistry());
        cr.addRegistry((Registry)new JndiRegistry());
        DefaultCamelContext context = new DefaultCamelContext((Registry)cr);
        context.start();
        CompositeRegistry comp = (CompositeRegistry)context.getRegistry(CompositeRegistry.class);
        GetRegistryAsTypeTest.assertNotNull((Object)comp);
        SimpleRegistry simple = (SimpleRegistry)context.getRegistry(SimpleRegistry.class);
        GetRegistryAsTypeTest.assertNotNull((Object)simple);
        JndiRegistry jndi = (JndiRegistry)context.getRegistry(JndiRegistry.class);
        GetRegistryAsTypeTest.assertNotNull((Object)jndi);
        context.stop();
    }
}

