/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class GzipDataFormatFileDeleteTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        GzipDataFormatFileDeleteTest.deleteDirectory("target/gzip");
        super.setUp();
    }

    public void testGzipFileDelete() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/gzip", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File in = new File("target/gzip/hello.txt");
        GzipDataFormatFileDeleteTest.assertFalse((String)("Should have been deleted " + in), (boolean)in.exists());
        File out = new File("target/gzip/out/hello.txt.gz");
        GzipDataFormatFileDeleteTest.assertTrue((String)("Should have been created " + out), (boolean)out.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/gzip?delete=true").marshal().gzip().to("file:target/gzip/out?fileName=${file:name}.gz")).to("mock:result");
            }
        };
    }
}

