/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultInflightRepository;
import org.apache.camel.spi.InflightRepository;

public class InflightRepositoryRouteTest
extends ContextTestSupport {
    public void testInflight() throws Exception {
        this.context.setInflightRepository((InflightRepository)new MyInflightRepo());
        InflightRepositoryRouteTest.assertEquals((int)0, (int)this.context.getInflightRepository().size());
        this.template.sendBody("direct:start", (Object)"Hello World");
        InflightRepositoryRouteTest.assertEquals((int)0, (int)this.context.getInflightRepository().size());
        InflightRepositoryRouteTest.assertEquals((int)0, (int)this.context.getInflightRepository().size("foo"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").to("mock:result");
            }
        };
    }

    private class MyInflightRepo
    extends DefaultInflightRepository {
        private MyInflightRepo() {
        }

        public void add(Exchange exchange) {
            super.add(exchange);
            TestCase.assertEquals((int)1, (int)InflightRepositoryRouteTest.this.context.getInflightRepository().size());
        }

        public void add(Exchange exchange, String routeId) {
            super.add(exchange, routeId);
            TestCase.assertEquals((int)1, (int)InflightRepositoryRouteTest.this.context.getInflightRepository().size("foo"));
        }
    }
}

