/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import junit.framework.TestCase;
import org.apache.camel.impl.JavaUuidGenerator;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUuidGeneratorTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(JavaUuidGeneratorTest.class);

    public void testGenerateUUID() {
        JavaUuidGenerator uuidGenerator = new JavaUuidGenerator();
        String firstUUID = uuidGenerator.generateUuid();
        String secondUUID = uuidGenerator.generateUuid();
        JavaUuidGeneratorTest.assertTrue((boolean)firstUUID.matches("^\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12}$"));
        JavaUuidGeneratorTest.assertTrue((boolean)secondUUID.matches("^\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12}$"));
        JavaUuidGeneratorTest.assertFalse((boolean)firstUUID.equals(secondUUID));
    }

    public void testPerformance() {
        JavaUuidGenerator uuidGenerator = new JavaUuidGenerator();
        StopWatch watch = new StopWatch();
        LOG.info("First id: " + uuidGenerator.generateUuid());
        for (int i = 0; i < 500000; ++i) {
            uuidGenerator.generateUuid();
        }
        LOG.info("Last id:  " + uuidGenerator.generateUuid());
        LOG.info("Took " + TimeUtils.printDuration((double)watch.stop()));
    }
}

