/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.DataFormat;

public class RefDataFormatTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("reverse", (Object)new MyReverseDataFormat());
        return jndi;
    }

    public void testMarshalRef() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"CBA"});
        this.template.sendBody("direct:a", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    public void testUnmarshalRef() throws Exception {
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"ABC"});
        this.template.sendBody("direct:b", (Object)"CBA");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:a").marshal().custom("reverse").to("mock:a");
                this.from("direct:b").unmarshal().custom("reverse").to("mock:b");
            }
        };
    }

    public static final class MyReverseDataFormat
    implements DataFormat {
        public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, graph);
            String body = this.reverseBytes(bytes);
            stream.write(body.getBytes());
        }

        public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
            byte[] bytes = (byte[])exchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, (Object)stream);
            String body = this.reverseBytes(bytes);
            return body;
        }

        private String reverseBytes(byte[] data) {
            StringBuilder sb = new StringBuilder(data.length);
            for (int i = data.length - 1; i >= 0; --i) {
                char ch = (char)data[i];
                sb.append(ch);
            }
            return sb.toString();
        }
    }
}

