/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.RoutePolicySupport;

public class RoutePolicyFactoryTest
extends ContextTestSupport {
    public void testRoutePolicyFactory() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("RoutePolicy", (Object)"foo-route");
        this.getMockEndpoint("mock:bar").expectedHeaderReceived("RoutePolicy", (Object)"bar-route");
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.template.sendBody("direct:bar", (Object)"Hello Bar");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                RoutePolicyFactoryTest.this.context.addRoutePolicyFactory((RoutePolicyFactory)new MyRoutePolicyFactory());
                this.from("direct:foo").routeId("foo-route").to("mock:foo");
                this.from("direct:bar").routeId("bar-route").to("mock:bar");
            }
        };
    }

    private static final class MyRoutePolicy
    extends RoutePolicySupport {
        private final String routeId;

        private MyRoutePolicy(String routeId) {
            this.routeId = routeId;
        }

        public String getRouteId() {
            return this.routeId;
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            exchange.getIn().setHeader("RoutePolicy", (Object)this.routeId);
        }
    }

    public static final class MyRoutePolicyFactory
    implements RoutePolicyFactory {
        public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, RouteDefinition route) {
            return new MyRoutePolicy(routeId);
        }
    }
}

