/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RuntimeEndpointRegistry;

public class RuntimeEndpointRegistryTest
extends ContextTestSupport {
    public void testRuntimeEndpointRegistry() throws Exception {
        RuntimeEndpointRegistry registry = this.context.getRuntimeEndpointRegistry();
        RuntimeEndpointRegistryTest.assertEquals((int)0, (int)registry.getAllEndpoints(false).size());
        RuntimeEndpointRegistryTest.assertEquals((int)2, (int)registry.getAllEndpoints(true).size());
        MockEndpoint mock = this.getMockEndpoint("mock:foo2");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:foo", (Object)"Hello World", "slip", (Object)"mock:foo2");
        mock.assertIsSatisfied();
        RuntimeEndpointRegistryTest.assertEquals((int)4, (int)registry.getAllEndpoints(true).size());
        RuntimeEndpointRegistryTest.assertEquals((int)3, (int)registry.getEndpointsPerRoute("foo", true).size());
        RuntimeEndpointRegistryTest.assertEquals((int)1, (int)registry.getEndpointsPerRoute("bar", true).size());
        mock = this.getMockEndpoint("mock:bar2");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("seda:bar", (Object)"Bye World", "slip", (Object)"mock:bar2");
        mock.assertIsSatisfied();
        RuntimeEndpointRegistryTest.assertEquals((int)6, (int)registry.getAllEndpoints(true).size());
        RuntimeEndpointRegistryTest.assertEquals((int)3, (int)registry.getEndpointsPerRoute("foo", true).size());
        RuntimeEndpointRegistryTest.assertEquals((int)3, (int)registry.getEndpointsPerRoute("bar", true).size());
        String json = this.context.createRouteStaticEndpointJson(null);
        RuntimeEndpointRegistryTest.assertNotNull((Object)json);
        this.log.info(json);
        RuntimeEndpointRegistryTest.assertTrue((String)"Should have outputs", (boolean)json.contains(" { \"uri\": \"mock://foo\" }"));
        RuntimeEndpointRegistryTest.assertTrue((String)"Should have outputs", (boolean)json.contains(" { \"uri\": \"mock://foo2\" }"));
        RuntimeEndpointRegistryTest.assertTrue((String)"Should have outputs", (boolean)json.contains(" { \"uri\": \"mock://bar\" }"));
        RuntimeEndpointRegistryTest.assertTrue((String)"Should have outputs", (boolean)json.contains(" { \"uri\": \"mock://bar2\" }"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("mock:foo")).recipientList((Expression)this.header("slip"));
                ((RouteDefinition)this.from("seda:bar").routeId("bar").to("mock:bar")).recipientList((Expression)this.header("slip"));
            }
        };
    }
}

