/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.MockScheduledPollConsumer;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public class ScheduledPollConsumerBackoffTest
extends ContextTestSupport {
    private static int commits;
    private static int errors;

    public void testBackoffIdle() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, null);
        consumer.setBackoffMultiplier(4);
        consumer.setBackoffIdleThreshold(2);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                commits++;
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) throws Exception {
                return false;
            }
        });
        consumer.start();
        consumer.run();
        consumer.run();
        ScheduledPollConsumerBackoffTest.assertEquals((int)2, (int)commits);
        consumer.run();
        consumer.run();
        consumer.run();
        consumer.run();
        ScheduledPollConsumerBackoffTest.assertEquals((int)2, (int)commits);
        consumer.run();
        consumer.run();
        ScheduledPollConsumerBackoffTest.assertEquals((int)4, (int)commits);
        consumer.run();
        consumer.run();
        consumer.run();
        consumer.run();
        ScheduledPollConsumerBackoffTest.assertEquals((int)4, (int)commits);
        consumer.run();
        ScheduledPollConsumerBackoffTest.assertEquals((int)5, (int)commits);
        consumer.stop();
    }

    public void testBackoffError() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        Exception expectedException = new Exception("Hello, I should be thrown on shutdown only!");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setBackoffMultiplier(4);
        consumer.setBackoffErrorThreshold(3);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                commits++;
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) throws Exception {
                errors++;
                return false;
            }
        });
        consumer.start();
        consumer.run();
        consumer.run();
        consumer.run();
        ScheduledPollConsumerBackoffTest.assertEquals((int)3, (int)errors);
        consumer.run();
        consumer.run();
        consumer.run();
        consumer.run();
        ScheduledPollConsumerBackoffTest.assertEquals((int)3, (int)errors);
        consumer.run();
        consumer.run();
        consumer.run();
        ScheduledPollConsumerBackoffTest.assertEquals((int)6, (int)errors);
        consumer.run();
        consumer.run();
        consumer.run();
        consumer.run();
        ScheduledPollConsumerBackoffTest.assertEquals((int)6, (int)errors);
        consumer.stop();
    }
}

