/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;

public class VetoCamelContextStartTest
extends ContextTestSupport {
    private LifecycleStrategy veto = new MyVeto();

    public void testVetoCamelContextStart() throws Exception {
        VetoCamelContextStartTest.assertEquals((boolean)false, (boolean)this.context.getStatus().isStarted());
        VetoCamelContextStartTest.assertEquals((boolean)true, (boolean)this.context.getStatus().isStopped());
        VetoCamelContextStartTest.assertEquals((int)0, (int)this.context.getRoutes().size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addLifecycleStrategy(this.veto);
        return context;
    }

    private class MyVeto
    extends LifecycleStrategySupport {
        private MyVeto() {
        }

        public void onContextStart(CamelContext context) throws VetoCamelContextStartException {
            throw new VetoCamelContextStartException("Forced", context, false);
        }
    }
}

