/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;

public class AdviceWithOnExceptionMultipleIssueTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).handled(true).to("mock:error");
                this.from("direct:startA").routeId("RouteA").to("mock:resultA");
                this.from("direct:startB").routeId("RouteB").to("mock:resultB");
            }
        };
    }

    public void testSimpleMultipleAdvice() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.getRouteDefinition("RouteA").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock:resultA").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                    }
                });
            }
        });
        this.context.getRouteDefinition("RouteB").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:resultA").expectedMessageCount(1);
        this.template.sendBody("direct:startA", (Object)"a trigger");
        this.assertMockEndpointsSatisfied();
    }

    public void testMultipleAdviceWithExceptionThrown() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.getRouteDefinition("RouteA").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock:resultA").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new Exception("my exception");
                    }
                });
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:resultA").expectedMessageCount(0);
        this.template.sendBody("direct:startA", (Object)"a trigger");
        this.assertMockEndpointsSatisfied();
    }

    public void testMultipleAdvice() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.getRouteDefinition("RouteA").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock:resultA").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new Exception("my exception");
                    }
                });
            }
        });
        this.context.getRouteDefinition("RouteB").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:resultA").expectedMessageCount(0);
        this.template.sendBody("direct:startA", (Object)"a trigger");
        this.assertMockEndpointsSatisfied();
    }
}

