/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;

public class AdviceWithTwoRoutesOnExceptionIssueTest
extends ContextTestSupport {
    public void testAdviceWith() throws Exception {
        this.context.getRouteDefinition("a").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock:a").skipSendToOriginalEndpoint().to("mock:error");
            }
        });
        this.context.getRouteDefinition("b").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("mock:b").skipSendToOriginalEndpoint().to("mock:error");
            }
        });
        this.getMockEndpoint("mock:error").whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                String body = (String)exchange.getIn().getBody(String.class);
                throw new IllegalArgumentException("Forced " + body);
            }
        });
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"A", "B"});
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Handling Forced A", "Handling Forced B"});
        Object outA = this.template.requestBody("direct:a", (Object)"A");
        AdviceWithTwoRoutesOnExceptionIssueTest.assertEquals((Object)"Handling Forced A", (Object)outA);
        Object outB = this.template.requestBody("direct:b", (Object)"B");
        AdviceWithTwoRoutesOnExceptionIssueTest.assertEquals((Object)"Handling Forced B", (Object)outB);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).setBody((Expression)this.simple("Handling ${exception.message}"))).to("mock:handled");
                this.from("direct:a").routeId("a").to("mock:a");
                this.from("direct:b").routeId("b").to("mock:b");
            }
        };
    }
}

