/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class ChoicePredicateSimpleHeaderTest
extends ContextTestSupport {
    public void testAAE() throws Exception {
        this.getMockEndpoint("mock:aae").expectedMessageCount(1);
        this.getMockEndpoint("mock:pca").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "Action", (Object)"AAE");
        this.assertMockEndpointsSatisfied();
    }

    public void testPCA() throws Exception {
        this.getMockEndpoint("mock:aae").expectedMessageCount(0);
        this.getMockEndpoint("mock:pca").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "Action", (Object)"PCA");
        this.assertMockEndpointsSatisfied();
    }

    public void testError() throws Exception {
        this.getMockEndpoint("mock:aae").expectedMessageCount(0);
        this.getMockEndpoint("mock:pca").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "Action", (Object)"Foo");
        this.assertMockEndpointsSatisfied();
    }

    public void testNoHeader() throws Exception {
        this.getMockEndpoint("mock:aae").expectedMessageCount(0);
        this.getMockEndpoint("mock:pca").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().simple("${in.header.Action} == 'AAE'")).to("mock:aae")).when().simple("${in.header.Action} == 'PCA'")).to("mock:pca")).otherwise().to("mock:error");
            }
        };
    }
}

