/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.InterceptDefinition;

public class InterceptFromLogTest
extends ContextTestSupport {
    public void testInterceptor() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((InterceptDefinition)this.interceptFrom().to("log:foo")).to("mock:foo");
                ((InterceptDefinition)this.interceptFrom().to("log:bar")).to("mock:bar");
                this.from("seda:foo").to("seda:bar");
                this.from("seda:bar").to("mock:result");
            }
        };
    }
}

