/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class MultipleErrorHandlerOnExceptionIssueTest
extends ContextTestSupport {
    public void testMultipleErrorHandlerOnExceptionA() throws Exception {
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead.a").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead.b").expectedMessageCount(0);
        this.template.sendBody("seda:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testMultipleErrorHandlerOnExceptionB() throws Exception {
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead.a").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead.b").expectedMessageCount(1);
        this.template.sendBody("seda:b", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:handled");
                ((RouteDefinition)this.from("seda:a").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead.a").maximumRedeliveries(3).redeliveryDelay(0L).retryAttemptedLogLevel(LoggingLevel.WARN).asyncDelayedRedelivery()).to("mock:a")).throwException((Exception)new IllegalArgumentException("Forced A"));
                ((RouteDefinition)this.from("seda:b").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead.b").maximumRedeliveries(2).redeliveryDelay(0L).retryAttemptedLogLevel(LoggingLevel.WARN)).to("mock:b")).throwException((Exception)new IOException("Some IO error"));
            }
        };
    }
}

