/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RomeksExceptionTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RomeksExceptionTest.class);

    public void testRouteA() throws Exception {
        this.assertErrorHandlingWorks("a");
    }

    public void testRouteB() throws Exception {
        this.assertErrorHandlingWorks("b");
    }

    protected void assertErrorHandlingWorks(String route) throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MockEndpoint exceptionEndpoint = this.getMockEndpoint("mock:exception");
        resultEndpoint.expectedMessageCount(0);
        exceptionEndpoint.expectedBodiesReceived(new Object[]{"<exception/>"});
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"<body/>", "route", (Object)route);
            RomeksExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException e) {
            RomeksExceptionTest.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            RomeksExceptionTest.assertEquals((String)"Exception thrown intentionally.", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        List list = exceptionEndpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        LOG.debug("Received: " + exchange.getIn());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        final Processor exceptionThrower = new Processor(){

            public void process(Exchange exchange) throws Exception {
                LOG.debug("About to throw exception on " + exchange);
                exchange.getIn().setBody((Object)"<exception/>");
                throw new IllegalArgumentException("Exception thrown intentionally.");
            }
        };
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").redeliveryDelay(0L));
                this.onException(IllegalArgumentException.class).to("mock:exception");
                ((RecipientListDefinition)this.from("direct:start").recipientList().simple("direct:${header.route}")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:a").setBody((Expression)this.constant("<some-value/>"))).process(exceptionThrower)).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").process(exceptionThrower)).setBody((Expression)this.constant("<some-value/>"))).to("mock:result");
            }
        };
    }
}

