/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.net.ConnectException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class RouteScopedOnExceptionWithInterceptSendToEndpointIssueTest
extends ContextTestSupport {
    public void testIssue() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        route.adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().throwException((Exception)new ConnectException("Forced"));
            }
        });
        this.getMockEndpoint("mock:global").expectedMessageCount(0);
        this.getMockEndpoint("mock:seda").expectedMessageCount(0);
        this.getMockEndpoint("mock:exhausted").expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            RouteScopedOnExceptionWithInterceptSendToEndpointIssueTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            ConnectException cause = RouteScopedOnExceptionWithInterceptSendToEndpointIssueTest.assertIsInstanceOf(ConnectException.class, e.getCause());
            RouteScopedOnExceptionWithInterceptSendToEndpointIssueTest.assertEquals((String)"Forced", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:global").maximumRedeliveries(2).redeliveryDelay(5000L));
                ((OnExceptionDefinition)this.from("direct:start").onException(ConnectException.class).maximumRedeliveries(5).redeliveryDelay(0L).logRetryAttempted(true).retryAttemptedLogLevel(LoggingLevel.WARN).to("mock:exhausted")).end().to("seda:foo");
            }
        };
    }
}

