/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.idempotent.FileIdempotentRepository;

public class SedaFileIdempotentIssueTest
extends ContextTestSupport {
    private final CountDownLatch latch = new CountDownLatch(1);
    private FileIdempotentRepository repository = new FileIdempotentRepository();

    @Override
    protected void setUp() throws Exception {
        SedaFileIdempotentIssueTest.deleteDirectory("target/inbox");
        SedaFileIdempotentIssueTest.createDirectory("target/inbox");
        File file = new File("target/inbox/hello.txt");
        FileOutputStream fos = new FileOutputStream(file, true);
        fos.write("Hello World".getBytes());
        fos.flush();
        fos.close();
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        this.repository.setFileStore(new File("target/repo.txt"));
        jndi.bind("repo", (Object)this.repository);
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(RuntimeException.class).process((Processor)new ShutDown());
                ((RouteDefinition)this.from("file:target/inbox?idempotent=true&noop=true&idempotentRepository=#repo&delay=1000").to("log:begin")).inOut("seda:process");
                this.from("seda:process").delay(1000L).throwException((Exception)new RuntimeException("Testing with exception"));
            }
        };
    }

    public void testRepo() throws Exception {
        boolean done = this.latch.await(10L, TimeUnit.SECONDS);
        SedaFileIdempotentIssueTest.assertTrue((String)"Should stop Camel", (boolean)done);
        SedaFileIdempotentIssueTest.assertEquals((String)"No file should be reported consumed", (int)0, (int)this.repository.getCache().keySet().size());
    }

    protected class ShutDown
    implements Processor {
        protected ShutDown() {
        }

        public void process(final Exchange exchange) throws Exception {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        SedaFileIdempotentIssueTest.this.log.info("Stopping Camel");
                        exchange.getContext().stop();
                        SedaFileIdempotentIssueTest.this.log.info("Stopped Camel complete");
                        SedaFileIdempotentIssueTest.this.latch.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();
        }
    }
}

