/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Iterator;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.issues.MyCloseableIterator;
import org.apache.camel.model.SplitDefinition;

public class SplitterUsingBeanReturningCloseableIteratorTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("mySplitter", (Object)new MyOtherSplitterBean());
        return jndi;
    }

    public void testCloseableIterator() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)"Hello,World");
        }
        catch (CamelExecutionException e) {
            SplitterUsingBeanReturningCloseableIteratorTest.assertTrue((String)"MyCloseableIterator.close() was not invoked", (boolean)MyCloseableIterator.getInstance().isClosed());
            return;
        }
        SplitterUsingBeanReturningCloseableIteratorTest.fail((String)"Exception should have been thrown");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((SplitDefinition)this.from("direct:start").split().method("mySplitter")).to(new String[]{"log:foo", "mock:result"});
            }
        };
    }

    public static class MyOtherSplitterBean {
        public Iterator<String> split(Exchange exchange) {
            return MyCloseableIterator.getInstance();
        }
    }
}

