/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;

public class TransactedPropertyPlaceholderIssueTest
extends ContextTestSupport {
    public void testPropertyPlaceholder() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Camel"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ProcessorDefinition)this.from("seda:foo").policy((Policy)new MyDummyPolicy()).setBody().constant((Object)"{{cool.name}}")).to("mock:result");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        context.addComponent("properties", (Component)pc);
        return context;
    }

    private static final class MyDummyPolicy
    implements Policy {
        private MyDummyPolicy() {
        }

        public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
        }

        public Processor wrap(RouteContext routeContext, Processor processor) {
            return processor;
        }
    }
}

