/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.InterceptStrategy;

public class TwoTimerWithJMXIssue
extends ContextTestSupport {
    private static int counter;

    @Override
    protected void setUp() throws Exception {
        this.enableJMX();
        super.setUp();
    }

    public void testFromWithNoOutputs() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(2);
        this.assertMockEndpointsSatisfied();
        TwoTimerWithJMXIssue.assertTrue((String)"Counter should be 2 or higher", (counter >= 2 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                TwoTimerWithJMXIssue.this.context.addInterceptStrategy((InterceptStrategy)new MyTracer());
                this.from("timer://kickoff_1?period=250").from("timer://kickoff_2?period=250&delay=10").to("mock:result");
            }
        };
    }

    private static class MyTracer
    implements InterceptStrategy {
        private MyTracer() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
            TestCase.assertNotNull((Object)target);
            counter++;
            return target;
        }
    }
}

