/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.MethodNotFoundException;

public class BeanLanguageInvalidOGNLTest
extends ContextTestSupport {
    public void testBeanLanguageInvalidOGNL() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().method(MyReallyCoolBean.class, "getOther[xx");
            }
        });
        try {
            this.context.start();
            BeanLanguageInvalidOGNLTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            RuntimeCamelException rce = BeanLanguageInvalidOGNLTest.assertIsInstanceOf(RuntimeCamelException.class, e.getCause());
            MethodNotFoundException mnfe = BeanLanguageInvalidOGNLTest.assertIsInstanceOf(MethodNotFoundException.class, rce.getCause());
            BeanLanguageInvalidOGNLTest.assertEquals((String)"getOther[xx", (String)mnfe.getMethodName());
            ExpressionIllegalSyntaxException cause = BeanLanguageInvalidOGNLTest.assertIsInstanceOf(ExpressionIllegalSyntaxException.class, mnfe.getCause());
            BeanLanguageInvalidOGNLTest.assertEquals((String)"Illegal syntax: getOther[xx", (String)cause.getMessage());
            BeanLanguageInvalidOGNLTest.assertEquals((String)"getOther[xx", (String)cause.getExpression());
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public static class MyReallyCoolBean {
        private Map<?, ?> map = new LinkedHashMap();

        public Map<?, ?> getOther() {
            return this.map;
        }
    }
}

