/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.Language;
import org.apache.camel.support.ServiceSupport;

public class LanguageServiceTest
extends ContextTestSupport {
    private MyLanguage my = new MyLanguage();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("my", (Object)this.my);
        return jndi;
    }

    public void testLanguageService() throws Exception {
        MyLanguage myl = (MyLanguage)this.context.resolveLanguage("my");
        LanguageServiceTest.assertNotNull((Object)((Object)myl));
        LanguageServiceTest.assertEquals((String)"Started", (String)myl.getState());
        LanguageServiceTest.assertEquals((int)1, (int)this.context.getLanguageNames().size());
        MyLanguage myl2 = (MyLanguage)this.context.resolveLanguage("my");
        LanguageServiceTest.assertNotNull((Object)((Object)myl2));
        LanguageServiceTest.assertSame((Object)((Object)myl), (Object)((Object)myl2));
        LanguageServiceTest.assertEquals((String)"Started", (String)myl2.getState());
        LanguageServiceTest.assertEquals((int)1, (int)this.context.getLanguageNames().size());
        this.context.stop();
        LanguageServiceTest.assertEquals((String)"Stopped", (String)myl.getState());
        LanguageServiceTest.assertTrue((boolean)this.context.getLanguageNames().isEmpty());
    }

    public void testNonSingletonLanguage() throws Exception {
        Language tol = this.context.resolveLanguage("tokenize");
        LanguageServiceTest.assertNotNull((Object)tol);
        LanguageServiceTest.assertEquals((int)1, (int)this.context.getLanguageNames().size());
        Language tol2 = this.context.resolveLanguage("tokenize");
        LanguageServiceTest.assertNotNull((Object)tol2);
        LanguageServiceTest.assertNotSame((Object)tol, (Object)tol2);
        LanguageServiceTest.assertEquals((int)1, (int)this.context.getLanguageNames().size());
        this.context.stop();
        LanguageServiceTest.assertTrue((boolean)this.context.getLanguageNames().isEmpty());
    }

    public class MyLanguage
    extends ServiceSupport
    implements Language,
    IsSingleton {
        private String state;

        public Predicate createPredicate(String expression) {
            return PredicateBuilder.constant((boolean)true);
        }

        public Expression createExpression(String expression) {
            return ExpressionBuilder.constantExpression((Object)expression);
        }

        public String getState() {
            return this.state;
        }

        protected void doStart() throws Exception {
            this.state = "Started";
        }

        protected void doStop() throws Exception {
            this.state = "Stopped";
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

