/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.main.Main;

public class MainTest
extends TestCase {
    public void testMain() throws Exception {
        Main main = new Main();
        main.addRouteBuilder((RouteBuilder)new MyRouteBuilder());
        main.bind("foo", (Object)new Integer(31));
        main.start();
        main.getCamelTemplate().sendBody("direct:start", (Object)"<message>1</message>");
        List contextList = main.getCamelContexts();
        MainTest.assertNotNull((Object)contextList);
        MainTest.assertEquals((String)"Did not get the expected count of Camel contexts", (int)1, (int)contextList.size());
        CamelContext camelContext = (CamelContext)contextList.get(0);
        MainTest.assertEquals((String)"Could not find the registry bound object", (Object)31, (Object)((DefaultCamelContext)camelContext).getRegistry().lookupByName("foo"));
        MockEndpoint endpoint = (MockEndpoint)camelContext.getEndpoint("mock:results", MockEndpoint.class);
        endpoint.expectedMinimumMessageCount(1);
        endpoint.assertIsSatisfied();
        main.stop();
    }

    public void testLoadingRouteFromCommand() throws Exception {
        Main main = new Main();
        main.parseArguments(new String[]{"-r", "org.apache.camel.main.MainTest$MyRouteBuilder"});
        main.start();
        main.getCamelTemplate().sendBody("direct:start", (Object)"<message>1</message>");
        List contextList = main.getCamelContexts();
        MainTest.assertNotNull((Object)contextList);
        MainTest.assertEquals((String)"Did not get the expected count of Camel contexts", (int)1, (int)contextList.size());
        CamelContext camelContext = (CamelContext)contextList.get(0);
        MockEndpoint endpoint = (MockEndpoint)camelContext.getEndpoint("mock:results", MockEndpoint.class);
        endpoint.expectedMinimumMessageCount(1);
        endpoint.assertIsSatisfied();
        main.stop();
    }

    public static class MyRouteBuilder
    extends RouteBuilder {
        public void configure() throws Exception {
            this.from("direct:start").to("mock:results");
        }
    }
}

