/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.EventNotifierSupport;

public class EventNotifierExchangeSentTest
extends ContextTestSupport {
    protected static List<EventObject> events = new ArrayList<EventObject>();

    @Override
    public void setUp() throws Exception {
        events.clear();
        super.setUp();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return true;
            }

            protected void doStart() throws Exception {
                this.setIgnoreCamelContextEvents(true);
                this.setIgnoreServiceEvents(true);
                this.setIgnoreRouteEvents(true);
                this.setIgnoreExchangeCreatedEvent(true);
                this.setIgnoreExchangeCompletedEvent(true);
                this.setIgnoreExchangeFailedEvents(true);
                this.setIgnoreExchangeRedeliveryEvents(true);
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    public void testExchangeSent() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        EventNotifierExchangeSentTest.assertEquals((int)8, (int)events.size());
        ExchangeSendingEvent e0 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(0));
        ExchangeSendingEvent e1 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(1));
        ExchangeSentEvent e2 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(2));
        ExchangeSendingEvent e3 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(3));
        ExchangeSentEvent e4 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(4));
        ExchangeSendingEvent e5 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(5));
        ExchangeSentEvent e6 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(6));
        ExchangeSentEvent e7 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(7));
        EventNotifierExchangeSentTest.assertEquals((String)"direct://start", (String)e0.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"log://foo", (String)e1.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"log://foo", (String)e2.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://bar", (String)e3.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://bar", (String)e4.getEndpoint().getEndpointUri());
        long time = e4.getTimeTaken();
        EventNotifierExchangeSentTest.assertTrue((String)("Should take about 0.5 sec, was: " + time), (time > 400L ? 1 : 0) != 0);
        EventNotifierExchangeSentTest.assertEquals((String)"mock://result", (String)e5.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"mock://result", (String)e6.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://start", (String)e7.getEndpoint().getEndpointUri());
        time = e7.getTimeTaken();
        EventNotifierExchangeSentTest.assertTrue((String)("Should take about 0.5 sec, was: " + time), (time > 400L ? 1 : 0) != 0);
    }

    public void testExchangeSentRecipient() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "foo", (Object)"direct:cool,direct:start");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(200L);
        EventNotifierExchangeSentTest.assertEquals((int)12, (int)events.size());
        ExchangeSendingEvent e0 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(0));
        ExchangeSendingEvent e1 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(1));
        ExchangeSentEvent e2 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(2));
        ExchangeSendingEvent e3 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(3));
        ExchangeSendingEvent e4 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(4));
        ExchangeSentEvent e5 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(5));
        ExchangeSendingEvent e6 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(6));
        ExchangeSentEvent e7 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(7));
        ExchangeSendingEvent e8 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, events.get(8));
        ExchangeSentEvent e9 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(9));
        ExchangeSentEvent e10 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(10));
        ExchangeSentEvent e11 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, events.get(11));
        EventNotifierExchangeSentTest.assertEquals((String)"direct://foo", (String)e0.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://cool", (String)e1.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://cool", (String)e2.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://start", (String)e3.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"log://foo", (String)e4.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"log://foo", (String)e5.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://bar", (String)e6.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://bar", (String)e7.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"mock://result", (String)e8.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"mock://result", (String)e9.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://start", (String)e10.getEndpoint().getEndpointUri());
        EventNotifierExchangeSentTest.assertEquals((String)"direct://foo", (String)e11.getEndpoint().getEndpointUri());
    }

    public void testExchangeWireTap() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:tap", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(200L);
        EventNotifierExchangeSentTest.assertEquals((int)6, (int)events.size());
        boolean found = false;
        boolean found2 = false;
        for (EventObject event : events) {
            ExchangeSentEvent sent;
            String uri;
            if (event instanceof ExchangeSendingEvent) {
                ExchangeSendingEvent sending = (ExchangeSendingEvent)event;
                uri = sending.getEndpoint().getEndpointUri();
                if (!"log://foo".equals(uri)) continue;
                found = true;
                continue;
            }
            if (!(event instanceof ExchangeSentEvent) || !"log://foo".equals(uri = (sent = (ExchangeSentEvent)event).getEndpoint().getEndpointUri())) continue;
            found2 = true;
        }
        EventNotifierExchangeSentTest.assertTrue((String)"We should find log:foo being wire tapped", (boolean)found);
        EventNotifierExchangeSentTest.assertTrue((String)"We should find log:foo being wire tapped", (boolean)found2);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("direct:bar")).to("mock:result");
                this.from("direct:bar").delay(500L);
                this.from("direct:foo").recipientList().header("foo");
                this.from("direct:cool").delay(1000L);
                this.from("direct:tap").wireTap("log:foo").to("mock:result");
            }
        };
    }
}

