/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class JmxRecipientListTest
extends ManagementTestSupport {
    public void testJmxEndpointsAddedDynamicallyDefaultRegister() throws Exception {
        if (JmxRecipientListTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"answer"});
        y.expectedBodiesReceived(new Object[]{"answer"});
        z.expectedBodiesReceived(new Object[]{"answer"});
        this.sendBody();
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"direct://a\"");
        JmxRecipientListTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://x\"");
        JmxRecipientListTest.assertFalse((String)"Should not be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://y\"");
        JmxRecipientListTest.assertFalse((String)"Should not be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://z\"");
        JmxRecipientListTest.assertFalse((String)"Should not be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=components,name=\"mock\"");
        JmxRecipientListTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
    }

    public void testJmxEndpointsAddedDynamicallyAlwaysRegister() throws Exception {
        if (JmxRecipientListTest.isPlatform("aix")) {
            return;
        }
        this.context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"answer"});
        y.expectedBodiesReceived(new Object[]{"answer"});
        z.expectedBodiesReceived(new Object[]{"answer"});
        this.sendBody();
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"direct://a\"");
        JmxRecipientListTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://x\"");
        JmxRecipientListTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://y\"");
        JmxRecipientListTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=endpoints,name=\"mock://z\"");
        JmxRecipientListTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
        name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=components,name=\"mock\"");
        JmxRecipientListTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(name));
    }

    protected void sendBody() {
        this.template.sendBodyAndHeader("direct:a", (Object)"answer", "recipientListHeader", (Object)"mock:x,mock:y,mock:z");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.header("recipientListHeader").tokenize(","));
            }
        };
    }
}

