/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedCamelContextAutoStartupTest
extends ManagementTestSupport {
    public void testManagedCamelContext() throws Exception {
        if (ManagedCamelContextAutoStartupTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        ObjectName onRoute = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"foo\"");
        ManagedCamelContextAutoStartupTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCamelContextAutoStartupTest.assertEquals((String)"camel-1", (String)name);
        ManagedCamelContextAutoStartupTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(onRoute));
        String state = (String)mbeanServer.getAttribute(onRoute, "State");
        ManagedCamelContextAutoStartupTest.assertEquals((String)"Stopped", (String)state);
        mbeanServer.invoke(onRoute, "start", null, null);
        state = (String)mbeanServer.getAttribute(onRoute, "State");
        ManagedCamelContextAutoStartupTest.assertEquals((String)"Started", (String)state);
        Object reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        ManagedCamelContextAutoStartupTest.assertEquals((Object)"Bye World", (Object)reply);
        mbeanServer.invoke(on, "stop", null, null);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedCamelContextAutoStartupTest.this.context.setAutoStartup(Boolean.valueOf(false));
                this.from("direct:foo").routeId("foo").transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

