/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.ConsumerCache;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedConsumerCacheTest
extends ManagementTestSupport {
    public void testManageConsumerCache() throws Exception {
        if (ManagedConsumerCacheTest.isPlatform("aix")) {
            return;
        }
        this.context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        ConsumerCache cache = new ConsumerCache((Object)this, (CamelContext)this.context);
        this.context.addService((Object)cache);
        this.template.sendBody("direct:start", (Object)"Hello World");
        Endpoint endpoint = this.context.getEndpoint("seda:queue");
        PollingConsumer consumer = cache.getConsumer(endpoint);
        Exchange out = consumer.receive(3000L);
        ManagedConsumerCacheTest.assertNotNull((String)"Should got an exchange", (Object)out);
        ManagedConsumerCacheTest.assertEquals((Object)"Hello World", (Object)out.getIn().getBody());
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("ConsumerCache")) continue;
            on = name;
            break;
        }
        ManagedConsumerCacheTest.assertNotNull((String)"Should have found ConsumerCache", on);
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumCacheSize");
        ManagedConsumerCacheTest.assertEquals((int)1000, (int)max);
        Integer current = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedConsumerCacheTest.assertEquals((int)1, (int)current);
        String source = (String)mbeanServer.getAttribute(on, "Source");
        ManagedConsumerCacheTest.assertNotNull((Object)source);
        ManagedConsumerCacheTest.assertTrue((boolean)source.contains("testManageConsumerCache"));
        mbeanServer.invoke(on, "purge", null, null);
        current = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedConsumerCacheTest.assertEquals((int)0, (int)current);
        consumer.stop();
        cache.stop();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("seda:queue");
            }
        };
    }
}

