/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ServiceStatus;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.ManagedManagementStrategy;

public class ManagedDualCamelContextTest
extends TestSupport {
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        return context;
    }

    public void testDualCamelContext() throws Exception {
        if (ManagedDualCamelContextTest.isPlatform("aix")) {
            return;
        }
        CamelContext camel1 = this.createCamelContext();
        camel1.start();
        CamelContext camel2 = this.createCamelContext();
        camel2.start();
        ManagedDualCamelContextTest.assertIsInstanceOf(ManagedManagementStrategy.class, camel1.getManagementStrategy());
        ManagedDualCamelContextTest.assertIsInstanceOf(ManagedManagementStrategy.class, camel2.getManagementStrategy());
        MBeanServer mbeanServer1 = camel1.getManagementStrategy().getManagementAgent().getMBeanServer();
        Set<ObjectName> set = mbeanServer1.queryNames(new ObjectName("*:context=camel-1,type=components,*"), null);
        ManagedDualCamelContextTest.assertEquals((int)2, (int)set.size());
        ObjectName on = set.iterator().next();
        ManagedDualCamelContextTest.assertTrue((String)"Should be registered", (boolean)mbeanServer1.isRegistered(on));
        String state = (String)mbeanServer1.getAttribute(on, "State");
        ManagedDualCamelContextTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String id = (String)mbeanServer1.getAttribute(on, "CamelId");
        ManagedDualCamelContextTest.assertEquals((String)"camel-1", (String)id);
        MBeanServer mbeanServer2 = camel2.getManagementStrategy().getManagementAgent().getMBeanServer();
        set = mbeanServer1.queryNames(new ObjectName("*:context=camel-2,type=components,*"), null);
        ManagedDualCamelContextTest.assertEquals((int)2, (int)set.size());
        on = set.iterator().next();
        ManagedDualCamelContextTest.assertTrue((String)"Should be registered", (boolean)mbeanServer2.isRegistered(on));
        state = (String)mbeanServer2.getAttribute(on, "State");
        ManagedDualCamelContextTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        id = (String)mbeanServer2.getAttribute(on, "CamelId");
        ManagedDualCamelContextTest.assertEquals((String)"camel-2", (String)id);
        camel1.stop();
        camel2.stop();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

