/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedNamePatternTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementNameStrategy().setNamePattern("cool-#name#");
        return context;
    }

    public void testManagedNamePattern() throws Exception {
        if (ManagedNamePatternTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ManagedNamePatternTest.assertTrue((boolean)this.context.getManagementName().startsWith("cool"));
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=" + this.context.getManagementName() + ",type=context,name=\"camel-1\"");
        ManagedNamePatternTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

