/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedRouteNoAutoStartupTest
extends ManagementTestSupport {
    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").noAutoStartup().to("mock:result");
            }
        };
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    public void testRouteNoAutoStartup() throws Exception {
        if (ManagedRouteNoAutoStartupTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteNoAutoStartupTest.getRouteObjectName(mbeanServer);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be stopped", (String)ServiceStatus.Stopped.name(), (String)state);
        mbeanServer.invoke(on, "start", null, null);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(1000L);
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRouteNoAutoStartupTest.assertEquals((long)1L, (long)completed);
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be 1 consumer", (int)1, (int)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be 1 processor", (int)1, (int)set.size());
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be stopped", (String)ServiceStatus.Stopped.name(), (String)state);
        set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be 0 consumer", (int)0, (int)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedRouteNoAutoStartupTest.assertEquals((String)"Should be 0 processor", (int)0, (int)set.size());
    }
}

