/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.WireTapDefinition;

public class GatherAllStaticEndpointUrisTest
extends ContextTestSupport {
    public void testGatherAllStaticEndpointUris() throws Exception {
        RouteDefinition route = this.context.getRouteDefinition("foo");
        Set uris = RouteDefinitionHelper.gatherAllStaticEndpointUris((CamelContext)this.context, (RouteDefinition)route, (boolean)true, (boolean)true);
        GatherAllStaticEndpointUrisTest.assertNotNull((Object)uris);
        GatherAllStaticEndpointUrisTest.assertEquals((int)5, (int)uris.size());
        RouteDefinition route2 = this.context.getRouteDefinition("bar");
        Set uris2 = RouteDefinitionHelper.gatherAllStaticEndpointUris((CamelContext)this.context, (RouteDefinition)route2, (boolean)true, (boolean)true);
        GatherAllStaticEndpointUrisTest.assertNotNull((Object)uris2);
        GatherAllStaticEndpointUrisTest.assertEquals((int)2, (int)uris2.size());
        Set uris2out = RouteDefinitionHelper.gatherAllStaticEndpointUris((CamelContext)this.context, (RouteDefinition)route2, (boolean)false, (boolean)true);
        GatherAllStaticEndpointUrisTest.assertNotNull((Object)uris2out);
        GatherAllStaticEndpointUrisTest.assertEquals((int)1, (int)uris2out.size());
        String json = this.context.createRouteStaticEndpointJson(null);
        GatherAllStaticEndpointUrisTest.assertNotNull((Object)json);
        GatherAllStaticEndpointUrisTest.assertTrue((boolean)json.contains("{ \"uri\": \"direct://foo\" }"));
        GatherAllStaticEndpointUrisTest.assertTrue((boolean)json.contains("{ \"uri\": \"seda://bar\" }"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((WireTapDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:foo").routeId("foo").to("seda:bar")).log("Hello World")).wireTap("mock:tap").to("mock:foo")).enrich("seda:stuff");
                ((RouteDefinition)this.from("seda:bar").routeId("bar").log("Bye World")).to("mock:bar");
            }
        };
    }
}

