/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.XmlTestSupport;

public class GenerateXmFromCamelContextTest
extends ContextTestSupport {
    public void testCreateRouteFromCamelContext() throws Exception {
        List list = this.context.getRouteDefinitions();
        GenerateXmFromCamelContextTest.assertEquals((String)("Size of list " + list), (int)1, (int)list.size());
        RouteDefinition routeType = (RouteDefinition)list.get(0);
        this.log.info("Found route: " + routeType);
        this.dump(routeType);
    }

    protected void dump(Object object) throws Exception {
        JAXBContext jaxbContext = XmlTestSupport.createJaxbContext();
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter buffer = new StringWriter();
        marshaller.marshal(object, (Writer)buffer);
        this.log.info("Created: " + buffer);
        GenerateXmFromCamelContextTest.assertNotNull((Object)buffer);
        String out = buffer.toString();
        GenerateXmFromCamelContextTest.assertTrue((String)"Should contain the description", (out.indexOf("<from uri=\"direct:start\"/>") > 0 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((FilterDefinition)this.from("direct:start").filter().xpath("/foo/bar = 'abc'")).to("mock:result");
            }
        };
    }
}

