/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.XPath;
import org.apache.camel.processor.BeanRouteTest;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanOgnMethodWithXPathInjectionTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();
    protected MyOtherBean myOtherBean = new MyOtherBean(this.myBean);

    public void testSendMessage() throws Exception {
        String expectedBody = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><foo>bar</foo></env:Body></env:Envelope>";
        Object out = this.template.requestBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        BeanOgnMethodWithXPathInjectionTest.assertEquals((Object)"bar", (Object)out);
        BeanOgnMethodWithXPathInjectionTest.assertEquals((String)("bean body: " + this.myBean), (String)expectedBody, (String)this.myBean.body);
        BeanOgnMethodWithXPathInjectionTest.assertEquals((String)("bean foo: " + this.myBean), (String)"bar", (String)this.myBean.foo);
    }

    public void testSendTwoMessages() throws Exception {
        String expectedBody = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><foo>bar</foo></env:Body></env:Envelope>";
        Object out = this.template.requestBodyAndHeader("direct:in", (Object)expectedBody, "foo", (Object)"bar");
        BeanOgnMethodWithXPathInjectionTest.assertEquals((Object)"bar", (Object)out);
        BeanOgnMethodWithXPathInjectionTest.assertEquals((String)("bean body: " + this.myBean), (String)expectedBody, (String)this.myBean.body);
        BeanOgnMethodWithXPathInjectionTest.assertEquals((String)("bean foo: " + this.myBean), (String)"bar", (String)this.myBean.foo);
        String expectedBody2 = "<env:Envelope xmlns:env='http://www.w3.org/2003/05/soap-envelope'><env:Body><foo>baz</foo></env:Body></env:Envelope>";
        Object out2 = this.template.requestBodyAndHeader("direct:in", (Object)expectedBody2, "foo", (Object)"bar");
        BeanOgnMethodWithXPathInjectionTest.assertEquals((Object)"baz", (Object)out2);
        BeanOgnMethodWithXPathInjectionTest.assertEquals((String)("bean body: " + this.myBean), (String)expectedBody2, (String)this.myBean.body);
        BeanOgnMethodWithXPathInjectionTest.assertEquals((String)("bean foo: " + this.myBean), (String)"baz", (String)this.myBean.foo);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        answer.bind("myOtherBean", (Object)this.myOtherBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").transform().method("myOtherBean", "doSomething.read");
            }
        };
    }

    public static class MyBean {
        public String body;
        public String foo;

        public String toString() {
            return "MyBean[foo: " + this.foo + " body: " + this.body + "]";
        }

        public String read(String body, @XPath(value="/soap:Envelope/soap:Body/foo/text()") String foo) {
            this.foo = foo;
            this.body = body;
            LOG.info("read() method called on " + this);
            return foo;
        }
    }

    public static class MyOtherBean {
        private final MyBean inner;

        public MyOtherBean(MyBean inner) {
            this.inner = inner;
        }

        public MyBean doSomething() {
            return this.inner;
        }
    }
}

