/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RecipientList;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanRecipientListTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRecipientListTest.class);
    protected MyBean myBean = new MyBean();

    public void testSendMessage() throws Exception {
        String expectedBody = "Wibble";
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Wibble"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Wibble"});
        this.template.sendBody("direct:in", (Object)"Wibble");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.checkBean();
    }

    protected void checkBean() throws Exception {
        Object lookedUpBean = this.context.getRegistry().lookupByName("myBean");
        BeanRecipientListTest.assertSame((String)"Lookup of 'myBean' should return same object!", (Object)this.myBean, (Object)lookedUpBean);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").beanRef("myBean", "route");
            }
        };
    }

    public static class MyBean {
        private static AtomicInteger counter = new AtomicInteger(0);
        private int id = counter.incrementAndGet();

        public String toString() {
            return "MyBean:" + this.id;
        }

        @RecipientList
        public String[] route(String body) {
            LOG.debug("Called " + this + " with body: " + body);
            return new String[]{"mock:a", "mock:b"};
        }
    }
}

