/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RecipientList;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.TimeoutAwareAggregationStrategy;
import org.apache.camel.util.jndi.JndiContext;

public class BeanRecipientListTimeoutTest
extends ContextTestSupport {
    private volatile Exchange receivedExchange;
    private volatile int receivedIndex;
    private volatile int receivedTotal;
    private volatile long receivedTimeout;

    public void testBeanRecipientListParallelTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((ValueBuilder)mock.message(0).body()).not(BeanRecipientListTimeoutTest.body().contains((Object)"A"));
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
        BeanRecipientListTimeoutTest.assertNotNull((Object)this.receivedExchange);
        BeanRecipientListTimeoutTest.assertEquals((int)0, (int)this.receivedIndex);
        BeanRecipientListTimeoutTest.assertEquals((int)3, (int)this.receivedTotal);
        BeanRecipientListTimeoutTest.assertEquals((long)1000L, (long)this.receivedTimeout);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)new MyBean());
        answer.bind("myStrategy", (Object)new MyAggregationStrategy());
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").beanRef("myBean", "route")).to("mock:result");
                this.from("direct:a").delay(2000L).setBody((Expression)this.constant("A"));
                this.from("direct:b").setBody((Expression)this.constant("B"));
                this.from("direct:c").delay(500L).setBody((Expression)this.constant("C"));
            }
        };
    }

    private class MyAggregationStrategy
    implements TimeoutAwareAggregationStrategy {
        private MyAggregationStrategy() {
        }

        public void timeout(Exchange oldExchange, int index, int total, long timeout) {
            BeanRecipientListTimeoutTest.this.receivedExchange = oldExchange;
            BeanRecipientListTimeoutTest.this.receivedIndex = index;
            BeanRecipientListTimeoutTest.this.receivedTotal = total;
            BeanRecipientListTimeoutTest.this.receivedTimeout = timeout;
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body = (String)oldExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
            return oldExchange;
        }
    }

    public static class MyBean {
        @RecipientList(strategyRef="myStrategy", parallelProcessing=true, timeout=1000L)
        public String[] route(String body) {
            return new String[]{"direct:a", "direct:b", "direct:c"};
        }
    }
}

