/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ChoiceDefinition;

public class CBRHeaderPredicateTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("cbrBean", (Object)new MyCBRBean());
        return jndi;
    }

    public void testCBR() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Hello Foo"});
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedBodiesReceived(new Object[]{"Hello Bar"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Foo", "foo", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Bar", "foo", (Object)"other");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().method("cbrBean", "checkHeader")).to("mock:foo")).otherwise().to("mock:bar")).end();
            }
        };
    }

    public static class MyCBRBean {
        public boolean checkHeader(Exchange exchange) {
            Message inMsg = exchange.getIn();
            String foo = (String)inMsg.getHeader("foo");
            return foo.equals("bar");
        }
    }
}

