/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ChoiceDefinition;

public class CBRPredicateBeanThrowExceptionTest
extends ContextTestSupport {
    private static AtomicBoolean check = new AtomicBoolean();
    private static AtomicBoolean check2 = new AtomicBoolean();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("cbrBean", (Object)new MyCBRBean());
        return jndi;
    }

    public void testCBR() throws Exception {
        check.set(false);
        check2.set(false);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Foo"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello Bar"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Foo", "foo", (Object)"bar");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Bar", "foo", (Object)"other");
        this.assertMockEndpointsSatisfied();
        CBRPredicateBeanThrowExceptionTest.assertTrue((boolean)check.get());
        CBRPredicateBeanThrowExceptionTest.assertTrue((boolean)check2.get());
    }

    public void testCBRKaboom() throws Exception {
        check.set(false);
        check2.set(false);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo2").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello Foo", "foo", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
        CBRPredicateBeanThrowExceptionTest.assertTrue((boolean)check.get());
        CBRPredicateBeanThrowExceptionTest.assertFalse((boolean)check2.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().method("cbrBean", "checkHeader")).to("mock:foo")).when().method("cbrBean", "checkHeader2")).to("mock:foo2")).otherwise().to("mock:bar")).end();
            }
        };
    }

    public static class MyCBRBean {
        public boolean checkHeader(Exchange exchange) {
            check.set(true);
            Message inMsg = exchange.getIn();
            String foo = (String)inMsg.getHeader("foo");
            if ("Kaboom".equalsIgnoreCase(foo)) {
                throw new IllegalArgumentException("Forced");
            }
            return foo.equals("bar");
        }

        public boolean checkHeader2(Exchange exchange) {
            check2.set(true);
            Message inMsg = exchange.getIn();
            String foo = (String)inMsg.getHeader("foo");
            if ("Kaboom".equalsIgnoreCase(foo)) {
                throw new IllegalArgumentException("Forced");
            }
            return foo.equals("bar");
        }
    }
}

