/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class ComposedMessageProcessorTest
extends ContextTestSupport {
    public void testValidatingCorrectOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.expectedHeaderReceived("orderId", (Object)"myorderid");
        List<OrderItem> order = Arrays.asList(new OrderItem("widget", 5), new OrderItem("gadget", 10));
        this.template.sendBodyAndHeader("direct:start", order, "orderId", (Object)"myorderid");
        this.assertMockEndpointsSatisfied();
        List validatedOrder = (List)((Exchange)resultEndpoint.getExchanges().get(0)).getIn().getBody(List.class);
        ComposedMessageProcessorTest.assertTrue((boolean)((OrderItem)validatedOrder.get((int)0)).valid);
        ComposedMessageProcessorTest.assertTrue((boolean)((OrderItem)validatedOrder.get((int)1)).valid);
    }

    public void testValidatingIncorrectOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.expectedHeaderReceived("orderId", (Object)"myorderid");
        List<OrderItem> order = Arrays.asList(new OrderItem("widget", 500), new OrderItem("gadget", 200));
        this.template.sendBodyAndHeader("direct:start", order, "orderId", (Object)"myorderid");
        this.assertMockEndpointsSatisfied();
        List validatedOrder = (List)((Exchange)resultEndpoint.getExchanges().get(0)).getIn().getBody(List.class);
        ComposedMessageProcessorTest.assertFalse((boolean)((OrderItem)validatedOrder.get((int)0)).valid);
        ComposedMessageProcessorTest.assertFalse((boolean)((OrderItem)validatedOrder.get((int)1)).valid);
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("orderItemHelper", (Object)new OrderItemHelper());
        jndi.bind("widgetInventory", (Object)new WidgetInventory());
        jndi.bind("gadgetInventory", (Object)new GadgetInventory());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((SplitDefinition)this.from("direct:start").split().body()).choice().when().method("orderItemHelper", "isWidget")).to("bean:widgetInventory")).otherwise().to("bean:gadgetInventory")).end().to("seda:aggregate");
                ((AggregateDefinition)this.from("seda:aggregate").aggregate((AggregationStrategy)new MyOrderAggregationStrategy()).header("orderId")).completionTimeout(1000L).to("mock:result");
            }
        };
    }

    public static final class MyOrderAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            ArrayList<Object> order = new ArrayList<Object>(2);
            order.add(oldExchange.getIn().getBody(OrderItem.class));
            order.add(newExchange.getIn().getBody(OrderItem.class));
            oldExchange.getIn().setBody(order);
            return oldExchange;
        }
    }

    public static final class GadgetInventory {
        public void checkInventory(@Body OrderItem orderItem) {
            TestCase.assertEquals((String)"gadget", (String)orderItem.type);
            if (orderItem.quantity < 20) {
                orderItem.valid = true;
            }
        }
    }

    public static final class WidgetInventory {
        public void checkInventory(@Body OrderItem orderItem) {
            TestCase.assertEquals((String)"widget", (String)orderItem.type);
            if (orderItem.quantity < 10) {
                orderItem.valid = true;
            }
        }
    }

    public static final class OrderItemHelper {
        private OrderItemHelper() {
        }

        public static boolean isWidget(@Body OrderItem orderItem) {
            return orderItem.type.equals("widget");
        }
    }

    public static final class OrderItem {
        String type;
        int quantity;
        boolean valid;

        public OrderItem(String type, int quantity) {
            this.type = type;
            this.quantity = quantity;
        }
    }
}

