/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DeadLetterChannelOnExceptionOnRedeliveryTest
extends ContextTestSupport {
    static int counter;

    public void testGlobalOnRedelivery() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World3"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testRouteSpecificOnRedelivery() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)mock.message(0).header("Timeout")).isEqualTo((Object)5000);
        this.template.sendBody("direct:io", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        counter = 0;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IOException.class).maximumRedeliveries(3).onRedelivery((Processor)new MyIORedeliverProcessor());
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").maximumRedeliveries(5).onRedelivery((Processor)new MyRedeliverProcessor()).redeliveryDelay(0L));
                ((RouteDefinition)this.from("direct:start").process((Processor)new ThrowExceptionProcessor())).to("mock:result");
                ((RouteDefinition)this.from("direct:io").process((Processor)new ThrowIOExceptionProcessor())).to("mock:result");
            }
        };
    }

    public static class ThrowIOExceptionProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            if (++counter <= 3) {
                throw new IOException("Cannot connect");
            }
        }
    }

    public static class ThrowExceptionProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            if (++counter <= 3) {
                throw new IllegalArgumentException("Forced by unit test");
            }
        }
    }

    public static class MyIORedeliverProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            exchange.getIn().setHeader("Timeout", (Object)5000);
        }
    }

    public static class MyRedeliverProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            int count = (Integer)exchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
            exchange.getIn().setBody((Object)(body + count));
        }
    }
}

