/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.DelayDefinition;

public class DelayerAsyncDelayedTest
extends ContextTestSupport {
    public void testSendingMessageGetsDelayed() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(0);
        resultEndpoint.setResultWaitTime(500L);
        this.template.sendBodyAndHeader("seda:a", (Object)"<hello>world!</hello>", "MyDelay", (Object)1000);
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.assertIsSatisfied();
    }

    public void testDelayConstant() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.setResultMinimumWaitTime(900L);
        this.template.sendBody("seda:b", (Object)"<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((DelayDefinition)this.from("seda:a").delay().header("MyDelay")).asyncDelayed().to("mock:result");
                this.from("seda:b").delay(1000L).asyncDelayed().to("mock:result");
            }
        };
    }
}

