/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.processor.ExchangeAwareDelayCalcBean;
import org.apache.camel.processor.MyDelayCalcBean;

public class DelayerTest
extends ContextTestSupport {
    private MyDelayCalcBean bean = new MyDelayCalcBean();
    private ExchangeAwareDelayCalcBean exchangeAwareBean = new ExchangeAwareDelayCalcBean();

    public void testSendingMessageGetsDelayed() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(0);
        resultEndpoint.setResultWaitTime(500L);
        this.template.sendBodyAndHeader("seda:a", (Object)"<hello>world!</hello>", "MyDelay", (Object)1000);
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.assertIsSatisfied();
    }

    public void testDelayConstant() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.setResultMinimumWaitTime(900L);
        this.template.sendBody("seda:b", (Object)"<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
    }

    public void testDelayBean() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.setResultMinimumWaitTime(900L);
        this.template.sendBody("seda:c", (Object)"<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
    }

    public void testExchangeAwareDelayBean() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.setResultMinimumWaitTime(900L);
        this.template.sendBodyAndHeader("seda:d", (Object)"<hello>world!</hello>", "BEAN_DELAYER_HEADER", (Object)1000);
        resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((DelayDefinition)this.from("seda:a").delay().header("MyDelay")).to("mock:result");
                this.from("seda:b").delay(1000L).to("mock:result");
                ((DelayDefinition)this.from("seda:c").delay().method((Object)DelayerTest.this.bean, "delayMe")).to("mock:result");
                ((DelayDefinition)this.from("seda:d").delay().method((Object)DelayerTest.this.exchangeAwareBean, "delayMe")).to("mock:result");
            }
        };
    }
}

