/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.Headers;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class DynamicRouterExchangeHeaders2Test
extends ContextTestSupport {
    private static List<String> bodies = new ArrayList<String>();
    private static List<String> previouses = new ArrayList<String>();

    public void testDynamicRouter() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:a").expectedHeaderReceived("invoked", (Object)1);
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedHeaderReceived("invoked", (Object)2);
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:c").expectedHeaderReceived("invoked", (Object)2);
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("invoked", (Object)3);
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:result").expectedHeaderReceived("invoked", (Object)4);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DynamicRouterExchangeHeaders2Test.assertEquals((int)5, (int)bodies.size());
        DynamicRouterExchangeHeaders2Test.assertEquals((String)"Hello World", (String)bodies.get(0));
        DynamicRouterExchangeHeaders2Test.assertEquals((String)"Hello World", (String)bodies.get(1));
        DynamicRouterExchangeHeaders2Test.assertEquals((String)"Hello World", (String)bodies.get(2));
        DynamicRouterExchangeHeaders2Test.assertEquals((String)"Bye World", (String)bodies.get(3));
        DynamicRouterExchangeHeaders2Test.assertEquals((String)"Bye World", (String)bodies.get(4));
        DynamicRouterExchangeHeaders2Test.assertEquals((int)4, (int)previouses.size());
        DynamicRouterExchangeHeaders2Test.assertEquals((String)"mock://a", (String)previouses.get(0));
        DynamicRouterExchangeHeaders2Test.assertEquals((String)"mock://c", (String)previouses.get(1));
        DynamicRouterExchangeHeaders2Test.assertEquals((String)"direct://foo", (String)previouses.get(2));
        DynamicRouterExchangeHeaders2Test.assertEquals((String)"mock://result", (String)previouses.get(3));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").dynamicRouter((Expression)this.method(DynamicRouterExchangeHeaders2Test.class, "slip"));
                ((RouteDefinition)this.from("direct:foo").transform((Expression)this.constant("Bye World"))).to("mock:foo");
            }
        };
    }

    public String slip(String body, @Headers Map<String, Object> headers, @Header(value="CamelSlipEndpoint") String previous) {
        bodies.add(body);
        if (previous != null) {
            previouses.add(previous);
        }
        int invoked = 0;
        Object current = headers.get("invoked");
        if (current != null) {
            invoked = Integer.valueOf(current.toString());
        }
        headers.put("invoked", ++invoked);
        if (invoked == 1) {
            return "mock:a";
        }
        if (invoked == 2) {
            return "mock:b,mock:c";
        }
        if (invoked == 3) {
            return "direct:foo";
        }
        if (invoked == 4) {
            return "mock:result";
        }
        return null;
    }
}

