/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.processor.ErrorHandlerSupport;

public class ErrorHandlerSupportTest
extends TestCase {
    public void testOnePolicyChildFirst() {
        ArrayList<Class> exceptions = new ArrayList<Class>();
        exceptions.add(ChildException.class);
        exceptions.add(ParentException.class);
        ShuntErrorHandlerSupport support = new ShuntErrorHandlerSupport();
        support.addExceptionPolicy(null, new OnExceptionDefinition(exceptions));
        ErrorHandlerSupportTest.assertEquals(ChildException.class, ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ChildException(), 0));
        ErrorHandlerSupportTest.assertEquals(ParentException.class, ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ParentException(), 1));
    }

    public void testOnePolicyChildLast() {
        ArrayList<Class> exceptions = new ArrayList<Class>();
        exceptions.add(ParentException.class);
        exceptions.add(ChildException.class);
        ShuntErrorHandlerSupport support = new ShuntErrorHandlerSupport();
        support.addExceptionPolicy(null, new OnExceptionDefinition(exceptions));
        ErrorHandlerSupportTest.assertEquals(ChildException.class, ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ChildException(), 1));
        ErrorHandlerSupportTest.assertEquals(ParentException.class, ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ParentException(), 0));
    }

    public void testTwoPolicyChildFirst() {
        ShuntErrorHandlerSupport support = new ShuntErrorHandlerSupport();
        support.addExceptionPolicy(null, new OnExceptionDefinition(ChildException.class));
        support.addExceptionPolicy(null, new OnExceptionDefinition(ParentException.class));
        ErrorHandlerSupportTest.assertEquals(ChildException.class, ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ChildException(), 0));
        ErrorHandlerSupportTest.assertEquals(ParentException.class, ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ParentException(), 0));
    }

    public void testTwoPolicyChildLast() {
        ShuntErrorHandlerSupport support = new ShuntErrorHandlerSupport();
        support.addExceptionPolicy(null, new OnExceptionDefinition(ParentException.class));
        support.addExceptionPolicy(null, new OnExceptionDefinition(ChildException.class));
        ErrorHandlerSupportTest.assertEquals(ChildException.class, ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ChildException(), 0));
        ErrorHandlerSupportTest.assertEquals(ParentException.class, ErrorHandlerSupportTest.getExceptionPolicyFor(support, new ParentException(), 0));
    }

    private static Class<? extends Throwable> getExceptionPolicyFor(ErrorHandlerSupport support, Throwable childException, int index) {
        return (Class)support.getExceptionPolicy(null, childException).getExceptionClasses().get(index);
    }

    private static class ShuntErrorHandlerSupport
    extends ErrorHandlerSupport {
        private ShuntErrorHandlerSupport() {
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }

        public boolean supportTransacted() {
            return false;
        }

        public Processor getOutput() {
            return null;
        }

        public void process(Exchange exchange) throws Exception {
        }
    }

    private static class ChildException
    extends ParentException {
        private static final long serialVersionUID = 1L;

        private ChildException() {
        }
    }

    private static class ParentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ParentException() {
        }
    }
}

