/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import java.net.SocketException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FailOverLoadBalanceWrappedExceptionNoLuckTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().failover(new Class[]{IOException.class}).to(new String[]{"direct:x", "direct:y"});
                ((RouteDefinition)this.from("direct:x").to("mock:x")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new SocketException("Forced");
                    }
                });
                ((RouteDefinition)this.from("direct:y").to("mock:y")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IOException("Forced");
                    }
                });
            }
        };
    }

    public void testWrappedException() throws Exception {
        this.x.expectedMessageCount(1);
        this.y.expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            FailOverLoadBalanceWrappedExceptionNoLuckTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            FailOverLoadBalanceWrappedExceptionNoLuckTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
            FailOverLoadBalanceWrappedExceptionNoLuckTest.assertIsInstanceOf(IOException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }
}

